<?php

header('Cache-Control: no-cache, no-store, must-revalidate'); // HTTP 1.1
header('Pragma: no-cache'); // HTTP 1.0
header('Expires: 0'); // Proxies
// Check if the PDF file exists and download it
$file = './pdfFile/The_Unit_All Collections.pdf'; // Path to the PDF file

if (file_exists($file)) {
    if (isset($_GET['download']) && $_GET['download'] == 1) {
        // Set headers for download
        header('Content-Description: File Transfer');
        header('Content-Type: application/pdf');
        header('Content-Disposition: attachment; filename="' . basename($file) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));

        // Read the file and send it to the output buffer
        readfile($file);
        exit;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Download PDF</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
  <link rel="stylesheet" type="text/css" href="./style/index.css">
</head>
<body>
<div class="container-fluid bg-image vh-100 d-flex justify-content-center align-items-center">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-md-6">
        <form class="row g-3 needs-validation border p-5 rounded bg-light">
          <img src="./image/undraw_cloud_files_wmo8.svg" class="m-auto img-fluid mb-3 d-block">
          <p class="text-center">Please wait while the PDF downloads automatically. If it does not, click the button below to download it manually.</p>
          <div class="col-12 text-center">
            <a href="getpdf.php?download=1" class="btn btn-danger m-auto">Download</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
<script>
// Automatically trigger the download on page load
document.addEventListener("DOMContentLoaded", function() {
    window.location.href = "getpdf.php?download=1";
});
</script>
</body>
</html>
